//scilab 5.5.2 , OS: Ubuntu 14.04
// This program will suppress noise at f=4000 Hz using Butterworth prototype
//pass band edge=f1=1500Hz
//stop band edge=f2=2000 Hz
//sampling rate =Fs=10000 Hz = 1/Ts
//passband attenuation = -1db
//stop attenuation = -3 db

clear all;clc;close;
f1=input('Enter the pass band edge(Hz)= ');
f2=input('Enter the stop band edge(Hz)= ');
k1=input('Enter the pass band attenuation(dB)= ');
k2=input('Enter the stop band attenuation(dB)= ');
fs=input('Enter the sampling rate(Hz)= ');

signal_fo=1000;
noise_fo=4000;

//Digital filter specifications(rad)
w1=2*%pi*f1*1/fs;
w2=2*%pi*f2*1/fs;

//Pre warping
o1=2*fs*tan(w1/2)
o2=2*fs*tan(w2/2)

//Design of analog filter
n=log10(((10.^(-k1/10))-1)/((10.^(-k2/10))-1))./(2*log10(o1/o2));
n=round(n);
wn= o2./((10.^(-k2/10)-1).^(1/(2*n)));

//[h,poles,zeros,gain]=analpf(n,'butt',[0 0],wn)hb.dt = 'c';
//[fr,hr]=repfreq(hb,fmin,fmax)

h=buttmag(n,wn,1:2*%pi*fs);
mag=20*log10(h)';
//plot2d((1:2*%pi*fs)',mag)
//xtitle('Analog IIR filter: lowpass','Analog frequency in rads/sec', 'dB',' ');

//Converting analog to digital filter 
hz=iir(n,'lp','butt',0.25,[])
//g*poly(z,'z')/poly(p,'z')

[hzm,fr]=frmag(hz,256);
magz=20*log10(hzm)';
fr1=fr*fs;
//figure;plot2d(fr1',magz');xtitle('Digital IIR filter: lowpass 0 < fr < 0.5','frequency', 'dB',' ');

//////note: Use zoom/axis commands to verify the design.
//These coefficients are to be read from variable hz (line 41, output of iir function)
num=[0.2928 0.5858 0.2928];
den=[1 0 0.1716];// In negative powers of z

//Signal generation (sine wave of frequency 1000 Hz) of length 1 second
t=0:1/fs:10/signal_fo;//10 cycles of input
original_signal=sin(2*%pi*signal_fo*t);

//Noise generation (sine wave of frequency 4000 Hz) of length 1 second
t=0:1/fs:10/signal_fo;
noise=sin(2*%pi*noise_fo*t);

noisy_signal=original_signal+noise;

filter_output=filter(num,den,noisy_signal);

//Plot original, noisy and filtered outputs

figure;subplot(3,1,1), plot2d(t,original_signal),xtitle('Original_signal','t','x(t)'),
subplot(3,1,2), plot2d(t,noisy_signal),xtitle('Noisy_signal','t','n(t)'),
subplot(3,1,3), plot2d(t,filter_output),xtitle('Filtered_signal','t','y(t)');
l1=length(original_signal);
l2=length(noisy_signal);
N=512;
x=[original_signal zeros(1,N-l1)];//To make it of length 512
n=[noisy_signal zeros(1,N-l1)];
y=[filter_output zeros(1,N-l1)];
X=fft(x);
N=fft(n);
Y=fft(y);
f=(0:511)*fs;
figure;
subplot(3,1,1), plot2d(f,abs(X)),xtitle('Original_signal','F','X(f)'),
subplot(3,1,2), plot2d(f,abs(N)),xtitle('Noisy_signal','F','N(f)'),
subplot(3,1,3), plot2d(f,abs(Y)),xtitle('Filtered_signal','F','Y(f)');

